<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Detil_perkara extends CI_Controller {
	function index(){
		$enc = $this->nativesession->get_flash_session('enc');
		if(empty($enc)){
			show_404();
		}
		$idperkara = $this->nativesession->get_flash_session('perkara_id');
		$idperkara = $this->encrypt->decode(base64_decode($enc));
		if(!is_numeric($idperkara)){
			redirect('main');
		}
		$this->show_data($idperkara,$enc);
	}

	function show_data($idperkara,$enc){
		$this->load->model('perkara/info_perkara','perkara');
		$data = $this->parseData($this->perkara->getInfoPerkara($idperkara));
		$data['idperkara']=$idperkara;
		$data['para_pihak'] = $this->perkara->getInfoPihak($idperkara);
		$data["ada_data_verzet"] = 0;
		$data["ada_data_intervensi"] = 0;
		$data["ada_data_diversi"] = 0;
		$data["ada_data_eksekusi"] = 0;
		$data['terdakwa_tidak_hadir'] = 0;
		$data['ada_data_rekonvensi'] = 0;
		$data["ada_data_banding"] = $this->perkara->getInfoBanding($idperkara);
		$data["ada_data_kasasi"] = $this->perkara->getInfoKasasi($idperkara);
		$data["ada_data_PK"] = $this->perkara->getInfoPK($idperkara);
		$data["ada_data_grasi"] = '';
		$data["ada_data_dismissal"] = 0;
		$data["ada_data_gugur"] = 0;
		$data["ada_data_penuntutan"] = 0;
		$data["ada_data_putusan_sela"] = $this->perkara->getInfoPutusanSela($idperkara);
		$data['ada_data_mediasi'] = 0;
		$data["ikrar_talak"] = 0;
		$data['ada_data_jadwal_sidang'] = $this->perkara->getInfoJadwalSidang($idperkara);;
		$data['ada_data_pen_persiapan'] = $this->perkara->getInfoPenPersiapan($idperkara);
		if($data['idalurperkara']==118){
			#$data['pihak_kedua'] = $this->perkara->getInfoPerkaraAnak($idperkara);
			#$data['pihak_korban'] = $this->perkara->getInfoKorbanAnak($idperkara);
		}
		if($data['idalurperkara']<100){
			#$data['pihak_keempat'] = $this->perkara->getInfoPihakKeempat($idperkara);
			$data["ada_data_verzet"] = $this->perkara->getInfoVerzet($idperkara);
			$data["ada_data_rekonvensi"] = $this->perkara->getInfoRekonvensi($idperkara);
			$data["ada_data_intervensi"] = $this->perkara->getInfoIntervensi($idperkara);
			$data["ada_data_eksekusi"] = $this->perkara->getInfoEksekusi($idperkara);
			if($data['idalurperkara']==8){
				$data["ada_data_keberatan"] = $this->perkara->getInfoKeberatan($idperkara);
				$infos = $this->perkara->getInfoPutusanPerdata($idperkara);
				if($infos==28){
					$data["ada_data_dismissal"] = 1;
				}elseif ($infos==29) {
					$data["ada_data_gugur"] = 1;
				}
			}
			$data['ada_data_mediasi'] = $this->perkara->getInfoMediasi($idperkara);
			if($data['idalurperkara']==9){
				$data["ada_data_dismissal"] = $this->perkara->getInfoPenDismissal($idperkara);
			}
			#$data['ada_data_rekonvensi'] = $this->perkara->getInfoRekonvensi($idperkara);
		}else{
			$data["ada_data_diversi"] = $this->perkara->getInfoDiversi($idperkara);
			$data["ada_data_grasi"] = $this->perkara->getInfoGrasi($idperkara);
			$data["ada_data_penuntutan"] = $this->perkara->getInfoPenuntutan($idperkara);
		}
		if($this->session->userdata('jenispengadilan')==2)
			$data["data_matra"] = $this->perkara->getInfoMatra($idperkara);
		elseif($this->session->userdata('jenispengadilan')==4)
			$data["ikrar_talak"] = $this->perkara->getInfoIkrarTalak($idperkara);
		
		$data["pengacara_pihak_pertama"] = $this->perkara->getInfoPengacara($idperkara,1);
		$data["pengacara_pihak_kedua"] = $this->perkara->getInfoPengacara($idperkara,2);
		$data["pengacara_pihak_keempat"] = $this->perkara->getInfoPengacara($idperkara,4);

		$data["ada_penetapan"] = $this->perkara->getInfoPenetapan($idperkara,4);
		
		$data['page_title'] = 'INFORMASI DETAIL PERKARA';
		$data['enc'] = $enc;
		$data['main_body'] = 'detil_perkara/detil_perkara';
		$data['main_history'] = $this->nativesession->get_flash_session('url_requested');
		$data['history'] = $data['main_history'];
		$this->load->vars($data);
		$this->load->view('header');
		$this->load->view('body/body_new');
	}


	function parseData($info_perkara){
		if($info_perkara!=''){
			if($info_perkara->num_rows>0){
				foreach ($info_perkara->result() as $row) {
					$data['idalurperkara'] = $row->klasifikasiPerkara;
					$data['IDJenisPerkara'] = $row->IDJenisPerkara;
					$data['noPerkara'] = $row->noPerkara;
					$data['tglSurat'] = $row->tglSurat;
					$data['noSurat'] = $row->noSurat;
					$data['idProses'] = $row->IDProses;
					$data['prosesText'] = $row->statusAkhir;
					$data['pihak1'] = $row->pihakPertama;
					$data['pihak2'] = $row->pihakKedua;
					$data['pihak3'] = $row->pihakKetiga;
					$data['pihak4'] = $row->pihakKeempat;
					$data['tglPendaftaran'] = $row->tglPendaftaran;
					$data['statuTerakhir'] = $row->statusAkhir;
					$data['tglPutusan'] = $row->tglPutusan;
					$data['jenisPerkara'] = $row->jenisPerkara;
					$data['isPublish'] = ($row->dipublikasikan=='Y')? 'Ya':'Tidak';
					$data['petitum'] = $row->petitumDakwaan;
					$data['pasalDakwaan'] = $row->pasalDakwaan;
					$data['nilai_sengketa'] = number_format($row->nilai_sengketa,2,",",".");
					$data['prodeo'] = ($row->prodeo=='1')? 'Ya':'Tidak';
				}
			}
		}
		return $data;
	}
}